
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Img {

    private BufferedImage imagem;
    private int largura;
    private int altura;
    int[][][] matriz;

    public void lerArquivo(String arquivo) {
        try {
            imagem = ImageIO.read(new File(arquivo));
            largura = getImagem().getWidth();
            altura = getImagem().getHeight();
            matriz = new int[largura][altura][3];
            for (int linha = 0; linha < altura; linha++) {
                for (int coluna = 0; coluna < largura; coluna++) {
                    Color pixel = new Color(getImagem().getRGB(coluna, linha));
                    matriz[coluna][linha][0] = pixel.getRed();
                    matriz[coluna][linha][1] = pixel.getGreen();
                    matriz[coluna][linha][2] = pixel.getBlue();
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(Img.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void lerMatriz() {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = matriz[coluna][linha][0];
                int g = matriz[coluna][linha][1];
                int b = matriz[coluna][linha][2];
                Color pixel = new Color(r, g, b);
                getImagem().setRGB(coluna, linha, pixel.getRGB());
            }
        }
    }
          
    public void changecolor(String color) {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = matriz[coluna][linha][0];
                int g = matriz[coluna][linha][1];
                int b = matriz[coluna][linha][2];
                
                if(color.equals("vermelho")){
                    matriz[coluna][linha][0] = r;
                    matriz[coluna][linha][1] = 0;
                    matriz[coluna][linha][2] = 0;
                }
                if(color.equals("azul")){
                    matriz[coluna][linha][0] = 0;
                    matriz[coluna][linha][1] = 0;
                    matriz[coluna][linha][2] = b;
                }
                if(color.equals("verde")){
                    matriz[coluna][linha][0] = 0;
                    matriz[coluna][linha][1] = g;
                    matriz[coluna][linha][2] = 0;
                }
                if(color.equals("cinza")){
                    int cinza = (r + g + b) / 3;
                    matriz[coluna][linha][0] = cinza;
                    matriz[coluna][linha][1] = cinza;
                    matriz[coluna][linha][2] = cinza;
                }
            }
        }
    }
    
    public void troca() {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = matriz[coluna][linha][0];
                int g = matriz[coluna][linha][1];
                int b = matriz[coluna][linha][2];
                matriz[coluna][linha][0] = g;
                matriz[coluna][linha][1] = b;//cinza;
                matriz[coluna][linha][2] = r;//cinza;
            }
        }
    }
     
    public void brilho(int valor) {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = valor + matriz[coluna][linha][0] ;
                int g = valor + matriz[coluna][linha][1] ;
                int b = valor + matriz[coluna][linha][2] ;
                
                if (r>255) {
                    r=255;
                } else if (r<0) {
                    r=0;
                }
                if (g>255) {
                    g=255;
                } else if (g<0) {
                    g=0;
                }
                if (b>255) {
                    b=255;
                } else if (b<0) {
                    b=0;
                }
                                
                matriz[coluna][linha][0] = r;
                matriz[coluna][linha][1] = g;
                matriz[coluna][linha][2] = b;
            }
        }
    }
    
    public void contraste(double valor) {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = (int) valor * matriz[coluna][linha][0];
                int g = (int) valor * matriz[coluna][linha][1] ;
                int b = (int) valor * matriz[coluna][linha][2] ;
                
                if (r>255) {
                    r=255;
                } else if (r<0) {
                    r=0;
                }
                if (g>255) {
                    g=255;
                } else if (g<0) {
                    g=0;
                }
                if (b>255) {
                    b=255;
                } else if (b<0) {
                    b=0;
                }
                
                matriz[coluna][linha][0] = r;
                matriz[coluna][linha][1] = g;
                matriz[coluna][linha][2] = b;
            }
        }
    }
    
    //Metodo inverte cores
    public void negativo() {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = 255 - matriz[coluna][linha][0];
                int g = 255 - matriz[coluna][linha][1];
                int b = 255 - matriz[coluna][linha][2];
                
                matriz[coluna][linha][0] = r;
                matriz[coluna][linha][1] = g;
                matriz[coluna][linha][2] = b;
            }
        }
    }
    
    //Binarizacao (Preto e Branco)
    //esse limiar vai falar o que vira preto e o que vira branco
    public void binarizacao(int limiar) {
        for (int linha = 0; linha < altura; linha++) {
            for (int coluna = 0; coluna < largura; coluna++) {
                int r = matriz[coluna][linha][0] ;
                int g = matriz[coluna][linha][1] ;
                int b = matriz[coluna][linha][2] ;
                int cinza = (r + g + b) / 3;
                if (cinza > limiar) {
                    r=255;
                } else {
                    r=0;
                }
                
                matriz[coluna][linha][0] = r;
                matriz[coluna][linha][1] = r;
                matriz[coluna][linha][2] = r;
            }
        }
    }
    
    public BufferedImage getImagem() {
        return imagem;
    }
    
    // Filtro passa baixa atenua rudo
    // Tambm chamado de filtro de borramento
    public void Filtro_Media_3x3() {
        int[][][] matriz2 = matriz.clone();
        
        for (int linha = 1; linha < altura -2; linha++) {
            for (int coluna = 1; coluna < largura -2; coluna++) {
                int r = (1 * matriz[coluna -1][linha -1][0] +
                        1 * matriz[coluna -1][linha +1][0] +
                        1 * matriz[coluna -1][linha][0] +
                        1 * matriz[coluna +1][linha -1][0] +
                        1 * matriz[coluna +1][linha +1][0] +
                        1 * matriz[coluna +1][linha][0] +
                        1 * matriz[coluna][linha -1][0] +
                        1 * matriz[coluna][linha +1][0] +
                        1 * matriz[coluna][linha][0] )/9;
                
                int g = (1 * matriz[coluna -1][linha -1][1] +
                        1 * matriz[coluna -1][linha +1][1] +
                        1 * matriz[coluna -1][linha][1] +
                        1 * matriz[coluna +1][linha -1][1] +
                        1 * matriz[coluna +1][linha +1][1] +
                        1 * matriz[coluna +1][linha][1] +
                        1 * matriz[coluna][linha -1][1] +
                        1 * matriz[coluna][linha +1][1] +
                        1 * matriz[coluna][linha][1] )/9;
                
                int b = (1 * matriz[coluna -1][linha -1][2] +
                        1 * matriz[coluna -1][linha +1][2] +
                        1 * matriz[coluna -1][linha][2] +
                        1 * matriz[coluna +1][linha -1][2] +
                        1 * matriz[coluna +1][linha +1][2] +
                        1 * matriz[coluna +1][linha][2] +
                        1 * matriz[coluna][linha -1][2] +
                        1 * matriz[coluna][linha +1][2] +
                        1 * matriz[coluna][linha][2] )/9;
                
                matriz2[coluna][linha][0] = r;
                matriz2[coluna][linha][1] = g;
                matriz2[coluna][linha][2] = b;
            }
        }
    }
    
    
    public void Filtro_Mediana_3x3() {
        int[][][] matriz2 = matriz.clone();
        int[] mediana = new int[9];
        
        for (int linha = 1; linha < altura -2; linha++) {
            for (int coluna = 1; coluna < largura -2; coluna++) {
  
                // INICIO DO PROCESSAMENTO DO RED
                mediana[0] = 1 * matriz[coluna -1][linha -1][0];
                mediana[1] = 1 * matriz[coluna -1][linha +1][0];
                mediana[2] = 1 * matriz[coluna -1][linha][0];
                mediana[3] = 1 * matriz[coluna +1][linha -1][0];
                mediana[4] = 1 * matriz[coluna +1][linha +1][0];
                mediana[5] = 1 * matriz[coluna +1][linha][0];
                mediana[6] = 1 * matriz[coluna][linha -1][0];
                mediana[7] = 1 * matriz[coluna][linha +1][0];
                mediana[8] = 1 * matriz[coluna][linha][0];
                
                Arrays.sort(mediana);
                // Red
                matriz2[coluna][linha][0] = mediana[mediana.length/2];

                // INICIO DO PROCESSAMENTO DO GREEN
                mediana[0] = 1 * matriz[coluna -1][linha -1][1];
                mediana[1] = 1 * matriz[coluna -1][linha +1][1];
                mediana[2] = 1 * matriz[coluna -1][linha][1];
                mediana[3] = 1 * matriz[coluna +1][linha -1][1];
                mediana[4] = 1 * matriz[coluna +1][linha +1][1];
                mediana[5] = 1 * matriz[coluna +1][linha][1];
                mediana[6] = 1 * matriz[coluna][linha -1][1];
                mediana[7] = 1 * matriz[coluna][linha +1][1];
                mediana[8] = 1 * matriz[coluna][linha][1];
                
                Arrays.sort(mediana);
                // Green
                matriz2[coluna][linha][1] = mediana[mediana.length/2];

                // INICIO DO PROCESSAMENTO DO BLUE
                mediana[0] = 1 * matriz[coluna -1][linha -1][2];
                mediana[1] = 1 * matriz[coluna -1][linha +1][2];
                mediana[2] = 1 * matriz[coluna -1][linha][2];
                mediana[3] = 1 * matriz[coluna +1][linha -1][2];
                mediana[4] = 1 * matriz[coluna +1][linha +1][2];
                mediana[5] = 1 * matriz[coluna +1][linha][2];
                mediana[6] = 1 * matriz[coluna][linha -1][2];
                mediana[7] = 1 * matriz[coluna][linha +1][2];
                mediana[8] = 1 * matriz[coluna][linha][2];
                
                Arrays.sort(mediana);
                // Blue
                matriz2[coluna][linha][2] = mediana[mediana.length/2];

            }
        }
    }
    
}
